/*****************************************************************************/
/*  Demonstration of using SFX DATA file format. This program displays sample*/
/*  DMP graphic files in 13h VGA mode (320x200x256). As it is only example,  */
/*  and has no error handling routines it may corrupt in some cases.         */
/*  Modifying allowed.  This file is part of ELITE exe compressor package.   */
/*****************************************************************************/
#include <dos.h>
#include<fcntl.h>
#include<io.h>

unsigned header[7];


#pragma inline

t_init_13h()                /* mode 13h initialisation */
{
asm mov ax,0013h
asm int 10h
return 0;
};

t_close_13h()              /* closing mode 13h */
{
asm mov ax,0003h
asm int 10h
return 0;
};

t_clrscr(char color)       /* clear screen procedure */
{
asm{
   push es
   push di
   mov ax,0a000h
   mov es,ax
   xor di,di
   mov cx,32000
   mov al,color
   mov ah,color
   rep stosw
   pop di
   pop es
   }
return 0;
}


char paleta[768];

ustaw_palete(unsigned ifile)      /* set palette procedure */
{
int R,G,B,count=0;
char color=0;

memset(&paleta,0,768);
asm{
   mov dx,3c8h
   mov al,0ffh
   out dx,al
   }

lseek(ifile,-768,SEEK_END);
while(count<768)
  {
  read(ifile,&paleta[count],1);
  count++;
  }
count=0;

while(count<768)
 {
 R=(char)paleta[count];
 G=(char)paleta[count+1];
 B=(char)paleta[count+2];
 asm{
     mov dx,3c8h
     mov al,color
     out dx,al
     inc dx

     mov al,R
     shr al,1
     shr al,1
     out dx,al

     mov al,G
     shr al,1
     shr al,1
     out dx,al

     mov al,B
     shr al,1
     shr al,1
     out dx,al
     }


 count+=3;
 color++;
 }

lseek(ifile,0,SEEK_SET);
return 0;
}






main(int argc,char **argv)    /* main program begins */
{
int l1,l2;
unsigned l3,imem,omem,ifile,ofile;
unsigned far *wsk;

_fmode = O_BINARY;
 
if(argc!=2) return 0;

ifile=open(argv[1],O_RDWR);

 read(ifile,&header,14);

 lseek(ifile,0,SEEK_SET);
 header[4]+=105;

 l1 = allocmem(header[4],&imem);

 if(l1!=-1) {
	      cprintf(" Memory allocation error \n\r");
	      return 22; }
	    else
	    {
	     cprintf("Allocated %lu bytes \n\r",(long)(header[4]+header[5])<<4);}


 lseek(ifile,0,SEEK_SET);

read(ifile,MK_FP(imem,0),filelength(ifile));
wsk=MK_FP(imem,0);
*(wsk+2)=0xa000;
t_init_13h();
ustaw_palete(ifile);

rundata(imem);              /* decompressing the picture directly */
                            /* to the video memory                */
while(kbhit()) getch();
while(!kbhit());
t_close_13h();

freemem(imem);
close(ifile);
return 0;
}



rundata(unsigned seg)   /* We have to use assembler here, because the decomp.*/
                        /* routine uses RETF to return to the caller. For    */
                        /* compilers that don't support assembler inserts we */
                        /* prepared TSR driver. Details in ELITE.DOC         */

{
asm{
  push cs             /* put our current segment on stack */
  mov ax,OFFSET nic11 /* current offset --> AX */
  push ax             /* put the offset on stack */
  push word ptr seg   /* put segment of loaded SFX DATA on stack */
  push word ptr 000   /* decompression routine =always= begins at seg:0000 */
  retf                /* jump to the decompression routine; this gets 2 words */
                      /* from the stack; procedure will return to nic11 label,*/
                      /* getting 2 words from stack as well */
  nic11 db 90h        /* this byte means NOP and is used only to determine  */
                      /* the right address */
  };

return 0;
};
